/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.preferences;

import com.aptana.editor.php.core.preferences.TaskTag;
import com.aptana.editor.php.epl.PHPEplPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import org2.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org2.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org2.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org2.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org2.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org2.eclipse.php.internal.core.preferences.PreferencesSupport;
import org2.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org2.eclipse.php.util.StringUtils;

public class TaskTagsProvider {
    private static TaskTagsProvider instance;
    private HashMap projectToTaskTagListener;
    private HashMap projectToPropagatorListeners;
    private boolean isInstalled;
    private PreferencesSupport preferencesSupport;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "com.aptana.editor.php.epl";
    private static final Preferences store;

    static {
        store = PHPEplPlugin.getDefault().getPluginPreferences();
    }

    private TaskTagsProvider() {
        this.install();
    }

    public static TaskTagsProvider getInstance() {
        if (instance == null) {
            instance = new TaskTagsProvider();
        }
        return instance;
    }

    public TaskTag[] getWorkspaceTaskTags() {
        String priorities = this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskPriorities");
        String tags = this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskTags");
        TaskTag[] workspaceTags = this.getTagsAndPropertiesFrom(tags, priorities);
        return workspaceTags;
    }

    public boolean isWorkspaceTagsCaseSensitive() {
        String caseSensitive = this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskCaseSensitive");
        return "enabled".equals(caseSensitive);
    }

    public TaskTag[] getProjectTaskTags(IProject project) {
        String priorities = this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskPriorities", null, project);
        String projectTags = this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskTags", null, project);
        if (projectTags == null || priorities == null) {
            return null;
        }
        TaskTag[] tags = this.getTagsAndPropertiesFrom(projectTags, priorities);
        return tags;
    }

    public boolean getProjectTagsCaseSensitive(IProject project) {
        String caseSensitive = this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskCaseSensitive", null, project);
        if (caseSensitive == null) {
            return this.isWorkspaceTagsCaseSensitive();
        }
        return "enabled".equals(caseSensitive);
    }

    public void addTaskTagsListener(ITaskTagsListener listener, IProject project) {
        this.projectToTaskTagListener.put(project, listener);
        this.installPropagatorListeners(project);
    }

    public void removeTaskTagsListener(ITaskTagsListener listener, IProject project) {
        this.projectToTaskTagListener.remove(project);
        this.uninstallPropagatorListeners(project);
    }

    private void installPropagatorListeners(IProject project) {
        if (project != null && this.projectToPropagatorListeners.get(project) != null) {
            return;
        }
        IPreferencesPropagatorListener[] listeners = new IPreferencesPropagatorListener[]{new InnerTaskTagsListener(project), new InnerTaskPrioritiesListener(project), new InnerTaskCaseListener(project)};
        if (project != null) {
            this.preferencesPropagator.addPropagatorListener(listeners[0], "com.aptana.editor.php.epl.taskTags");
            this.preferencesPropagator.addPropagatorListener(listeners[1], "com.aptana.editor.php.epl.taskPriorities");
            this.preferencesPropagator.addPropagatorListener(listeners[2], "com.aptana.editor.php.epl.taskCaseSensitive");
        }
        this.projectToPropagatorListeners.put(project, listeners);
    }

    private void uninstallPropagatorListeners(IProject project) {
        IPreferencesPropagatorListener[] listeners = (IPreferencesPropagatorListener[])this.projectToPropagatorListeners.get(project);
        if (listeners != null && project != null) {
            this.preferencesPropagator.removePropagatorListener(listeners[0], "com.aptana.editor.php.epl.taskTags");
            this.preferencesPropagator.removePropagatorListener(listeners[1], "com.aptana.editor.php.epl.taskPriorities");
            this.preferencesPropagator.removePropagatorListener(listeners[2], "com.aptana.editor.php.epl.taskCaseSensitive");
        }
        this.projectToPropagatorListeners.remove(project);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER, PHPEplPlugin.getDefault().getPluginPreferences());
        this.projectToTaskTagListener = new HashMap();
        this.projectToPropagatorListeners = new HashMap();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        Set keys = this.projectToPropagatorListeners.keySet();
        IProject[] projects = new IProject[keys.size()];
        keys.toArray(projects);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            this.uninstallPropagatorListeners(element);
            ++n2;
        }
        this.preferencesSupport = null;
        this.preferencesPropagator = null;
        this.projectToTaskTagListener = null;
        this.projectToPropagatorListeners = null;
        this.isInstalled = false;
    }

    private void notifyTaskTagChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskTagsChanged(event);
            ++n2;
        }
    }

    private void notifyTaskPriorityChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskPrioritiesChanged(event);
            ++n2;
        }
    }

    private void notifyTaskCaseChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskCaseChanged(event);
            ++n2;
        }
    }

    private TaskTag[] getTagsAndPropertiesFrom(String tagString, String priorityString) {
        String[] tags = StringUtils.unpack(tagString);
        String[] priorities = StringUtils.unpack(priorityString);
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] stringArray = priorities;
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Integer number = null;
            number = "HIGH".equals(element) ? new Integer(2) : ("LOW".equals(element) ? new Integer(0) : new Integer(1));
            list.add(number);
            ++n2;
        }
        Integer[] allPriorities = new Integer[list.size()];
        list.toArray(allPriorities);
        TaskTag[] taskTags = new TaskTag[Math.min(tags.length, priorities.length)];
        int i = 0;
        while (i < taskTags.length) {
            taskTags[i] = new TaskTag(tags[i], allPriorities[i]);
            ++i;
        }
        return taskTags;
    }

    private abstract class AbstractTasksListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public AbstractTasksListener(IProject project) {
            this.project = project;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }

    private class InnerTaskCaseListener
    extends AbstractTasksListener {
        public InnerTaskCaseListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskTags", null, this.getProject());
            String priorities = null;
            if (tags == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskTags");
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskPriorities");
            } else {
                priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskPriorities", "", this.getProject());
            }
            if (StringUtils.occurrencesOf(priorities, ',') == StringUtils.occurrencesOf(tags, ',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(tags, priorities);
                TaskTagsEvent taskEvent = null;
                String newValue = (String)event.getNewValue();
                if (newValue == null) {
                    newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskCaseSensitive");
                }
                taskEvent = "enabled".equals(newValue) ? new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, true) : new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, false);
                TaskTagsProvider.this.notifyTaskCaseChange(taskEvent);
            }
        }
    }

    private class InnerTaskPrioritiesListener
    extends AbstractTasksListener {
        public InnerTaskPrioritiesListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags;
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskPriorities");
            }
            if ((tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskTags", null, this.getProject())) == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskTags");
            }
            if (StringUtils.occurrencesOf(tags, ',') == StringUtils.occurrencesOf(newValue, ',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(tags, newValue);
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskPriorityChange(taskEvent);
            }
        }
    }

    private class InnerTaskTagsListener
    extends AbstractTasksListener {
        public InnerTaskTagsListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String priorities;
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskTags");
            }
            if ((priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("com.aptana.editor.php.epl.taskPriorities", null, this.getProject())) == null) {
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("com.aptana.editor.php.epl.taskPriorities");
            }
            if (StringUtils.occurrencesOf(priorities, ',') == StringUtils.occurrencesOf(newValue, ',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(newValue, priorities);
                IProject eventProject = event.getSource() != null && event.getSource() instanceof IProject ? (IProject)event.getSource() : null;
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, eventProject, taskTags, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskTagChange(taskEvent);
            }
        }
    }
}

